#include<intrins.h>
#define uchar unsigned char
#define uint  unsigned int

/**********  NRF24L01Ĵ  ***********/
#define READ_REG        0x00  //üĴ,5λΪĴַ
#define WRITE_REG       0x20  //дüĴ,5λΪĴַ
#define RD_RX_PLOAD     0x61  //RXЧ,1~32ֽ
#define WR_TX_PLOAD     0xA0  //дTXЧ,1~32ֽ
#define FLUSH_TX        0xE1  //TX FIFOĴ.ģʽ
#define FLUSH_RX        0xE2  //RX FIFOĴ.ģʽ
#define REUSE_TX_PL     0xE3  //ʹһ,CEΪ,ݰϷ.
#define NOP             0xFF  //ղ,״̬Ĵ	 
/**********  NRF24L01Ĵַ   *************/
#define CONFIG          0x00  //üĴַ                             
#define EN_AA           0x01  //ʹԶӦ 
#define EN_RXADDR       0x02  //յַ
#define SETUP_AW        0x03  //õַ(ͨ)
#define SETUP_RETR      0x04  //Զط
#define RF_CH           0x05  //RFͨ
#define RF_SETUP        0x06  //RFĴ
#define STATUS          0x07  //״̬Ĵ
#define OBSERVE_TX      0x08  // ͼĴ
#define CD              0x09  // زĴ
#define RX_ADDR_P0      0x0A  // ͨ0յַ
#define RX_ADDR_P1      0x0B  // ͨ1յַ
#define RX_ADDR_P2      0x0C  // ͨ2յַ
#define RX_ADDR_P3      0x0D  // ͨ3յַ
#define RX_ADDR_P4      0x0E  // ͨ4յַ
#define RX_ADDR_P5      0x0F  // ͨ5յַ
#define TX_ADDR         0x10  // ͵ַĴ
#define RX_PW_P0        0x11  // ͨ0Чݿ(1~32ֽ) 
#define RX_PW_P1        0x12  // ͨ1Чݿ(1~32ֽ) 
#define RX_PW_P2        0x13  // ͨ2Чݿ(1~32ֽ) 
#define RX_PW_P3        0x14  // ͨ3Чݿ(1~32ֽ) 
#define RX_PW_P4        0x15  // ͨ4Чݿ(1~32ֽ)
#define RX_PW_P5        0x16  // ͨ5Чݿ(1~32ֽ)
#define FIFO_STATUS     0x17  // FIFO״̬Ĵ
/**/

/******   STATUSĴbitλ      *******/
#define MAX_TX  	0x10  	  //ﵽʹж
#define TX_OK   	0x20  	  //TXж
#define RX_OK   	0x40  	  //յж
/**/

/*********     24L01ͽݿȶ	  ***********/
#define TX_ADR_WIDTH    5     //5ֽڵַ
#define RX_ADR_WIDTH    5     //5ֽڵַ
#define TX_PLOAD_WIDTH  32    //32ֽЧݿ
#define RX_PLOAD_WIDTH  32    //32ֽЧݿ

sbit NRF_CE   = P1^1;
sbit NRF_CSN  = P1^2;
sbit NRF_SCK  = P1^5;
sbit NRF_MOSI = P1^3;
sbit NRF_MISO = P1^4;  
sbit NRF_IRQ  = P1^6;	

void delay_us(uchar num)
{
	uchar i; 
	for(i=0;i<num;i++)
 	_nop_();
}
void delay_150us()
{
	uint i;	
	for(i=0;i<150;i++);
}
/***************************************************************/

/*******************************************************************/
uchar SPI_RW(uchar byte)
{
	uchar bit_ctr;
	for(bit_ctr=0;bit_ctr<8;bit_ctr++)  // 8λ
	{
		NRF_MOSI=(byte&0x80); 			// MSB TO MOSI
		byte=(byte<<1);					// shift next bit to MSB
		NRF_SCK=1;
		byte|=NRF_MISO;	        		// capture current MISO bit
		NRF_SCK=0;
	}
	return byte;
}

/*********************************************/
/* ܣ24L01ļĴдֵһֽڣ */
/* ڲreg   ҪдļĴַ          */
/*           value Ĵдֵ            */
/* ڲstatus ״ֵ̬                   */
/*********************************************/
uchar NRF24L01_Write_Reg(uchar reg,uchar value)
{
	uchar status;
	NRF_CSN=0;                  //CSN=0;   
  	status = SPI_RW(reg);		//ͼĴַ,ȡ״ֵ̬
	SPI_RW(value);
	NRF_CSN=1;                  //CSN=1;

	return status;
}
/*************************************************/
/* ܣ24L01ļĴֵ һֽڣ      */
/* ڲreg  ҪļĴַ               */
/* ڲvalue Ĵֵ                */
/*************************************************/
uchar NRF24L01_Read_Reg(uchar reg)
{
 	uchar value;

	NRF_CSN=0;              //CSN=0;   
  	SPI_RW(reg);			//ͼĴֵ(λ),ȡ״ֵ̬
	value = SPI_RW(NOP);
	NRF_CSN=1;             	//CSN=1;

	return value;
}
/*********************************************/
/* ܣ24L01ļĴֵֽڣ   */
/* ڲreg   Ĵַ                */
/*           *pBuf ĴֵĴ    */
/*           len   ֽڳ              */
/* ڲstatus ״ֵ̬                   */
/*********************************************/
uchar NRF24L01_Read_Buf(uchar reg,uchar *pBuf,uchar len)
{
	uchar status,u8_ctr;
	NRF_CSN=0;                   	//CSN=0       
  	status=SPI_RW(reg);				//ͼĴַ,ȡ״ֵ̬   	   
 	for(u8_ctr=0;u8_ctr<len;u8_ctr++)
	pBuf[u8_ctr]=SPI_RW(0XFF);		//
	NRF_CSN=1;                 		//CSN=1
  	return status;        			//ض״ֵ̬
}
/**********************************************/
/* ܣ24L01ļĴдֵֽڣ  */
/* ڲreg  ҪдļĴַ            */
/*           *pBuf ֵĴ               */
/*           len   ֽڳ               */
/**********************************************/
uchar NRF24L01_Write_Buf(uchar reg, uchar *pBuf, uchar len)
{
	uchar status,u8_ctr;
	NRF_CSN=0;
  	status = SPI_RW(reg);			//ͼĴֵ(λ),ȡ״ֵ̬
  	for(u8_ctr=0; u8_ctr<len; u8_ctr++)
	SPI_RW(*pBuf++); 				//д
	NRF_CSN=1;
  	return status;          		//ض״ֵ̬
}							  					   

/*********************************************/
/* ܣ24L01                   */
/* ڲrxbuf               */
/* ֵ 0   ɹյ                 */
/*          1   ûյ                 */
/*********************************************/
uchar NRF24L01_RxPacket(uchar *rxbuf)
{
	uchar state;
	 
	state=NRF24L01_Read_Reg(STATUS);  			//ȡ״̬Ĵֵ    	 
	NRF24L01_Write_Reg(WRITE_REG+STATUS,state); //TX_DSMAX_RTжϱ־
	if(state&RX_OK)								//յ
	{
		NRF_CE = 0;
		NRF24L01_Read_Buf(RD_RX_PLOAD,rxbuf,RX_PLOAD_WIDTH);//ȡ
		NRF24L01_Write_Reg(FLUSH_RX,0xff);					//RX FIFOĴ
		NRF_CE = 1;
		delay_150us(); 
		return 0; 
	}	   
	return 1;//ûյκ
}
/**********************************************/
/* ܣ24L01Ϊģʽ              */
/* ڲtxbuf                */
/* ֵ 0x10    ﵽطʧ*/
/*          0x20    ɹ              */
/*          0xff    ʧ                  */
/**********************************************/
uchar NRF24L01_TxPacket(uchar *txbuf)
{
	uchar state;
   
	NRF_CE=0;												//CEͣʹ24L01
  	NRF24L01_Write_Buf(WR_TX_PLOAD,txbuf,TX_PLOAD_WIDTH);	//дݵTX BUF  32ֽ
 	NRF_CE=1;												//CEøߣʹܷ	   
	while(NRF_IRQ==1);										//ȴ
	state=NRF24L01_Read_Reg(STATUS);  						//ȡ״̬Ĵֵ	   
	NRF24L01_Write_Reg(WRITE_REG+STATUS,state); 			//TX_DSMAX_RTжϱ־
	if(state&MAX_TX)										//ﵽط
	{
		NRF24L01_Write_Reg(FLUSH_TX,0xff);					//TX FIFOĴ 
		return MAX_TX; 
	}
	if(state&TX_OK)											//
	{
		return TX_OK;
	}
	return 0xff;											//ʧ
}

/********************************************/
/* ܣ24L01Ƿ              */
/* ֵ  0                          */
/*           1                        */
/********************************************/ 	  
uchar NRF24L01_Check(void)
{
	uchar check_in_buf[5]={0x11,0x22,0x33,0x44,0x55};
	uchar check_out_buf[5]={0x00};	
	NRF_SCK=0;
	NRF_CSN=1;    
	NRF_CE=0;

	NRF24L01_Write_Buf(WRITE_REG+TX_ADDR, check_in_buf, 5);

	NRF24L01_Read_Buf(READ_REG+TX_ADDR, check_out_buf, 5);

	if((check_out_buf[0] == 0x11)&&\
	   (check_out_buf[1] == 0x22)&&\
	   (check_out_buf[2] == 0x33)&&\
	   (check_out_buf[3] == 0x44)&&\
	   (check_out_buf[4] == 0x55))return 0;
	else return 1;
}	

/**********************************************/
/* ܣ24L01ʼ                      */
/* ڲPLOAD_WIDTH  Чݿ        */
/* 			 TX_ADR  ͵ַ		          */
/* 		     TX_ADDR_WIDTH  ͵ַ      */
/* 			 RX_ADR  շ͵ַ        	  */
/* 			 RX_ADDR_WIDTH  յַ      */
/* 			 RATE  Чݿ        		  */
/* ֵ  	     	                      */
/**********************************************/
void NRF24L01_RT_Init(uchar PLOAD_WIDTH,uchar *TX_ADR,uchar TX_ADDR_WIDTH,uchar *RX_ADR,uchar RX_ADDR_WIDTH,uchar RATE)
{	
	NRF_CE=0;		  
	NRF24L01_Write_Reg(WRITE_REG + RX_PW_P0, PLOAD_WIDTH); //ýݳȣΪ32ֽ
	NRF24L01_Write_Reg(FLUSH_RX,0xff);//RX FIFOĴ    
  	NRF24L01_Write_Buf(WRITE_REG + TX_ADDR, TX_ADR,TX_ADDR_WIDTH);//дTXڵַ 
	NRF24L01_Write_Buf(WRITE_REG + RX_ADDR_P0, RX_ADR,RX_ADDR_WIDTH); //RXڵַ,ҪΪʹACK
		  
  	NRF24L01_Write_Reg(WRITE_REG+EN_AA,0x01);     //ʹͨ0ԶӦ    
  	NRF24L01_Write_Reg(WRITE_REG+EN_RXADDR,0x01); //ʹͨ0Ľյַ
 
  	NRF24L01_Write_Reg(WRITE_REG+SETUP_RETR,0x1a);//Զطʱ:500us + 86us;Զط:10(a)
  	NRF24L01_Write_Reg(WRITE_REG+RF_CH,0);       //RFͨΪ0 շһ£0Ϊ2.4GHz
  	NRF24L01_Write_Reg(WRITE_REG+RF_SETUP,RATE);  //TX,0db,1Mbps,濪   
  	NRF24L01_Write_Reg(WRITE_REG+CONFIG,0x0f);    //ûģʽĲ;PWR_UP,EN_CRC,16BIT_CRC,ģʽ,ж
	NRF_CE=1;					//CEøߣʹܷ
}
/**********************************************/
/* ܣ亯                     	  */
/* ڲbuf  ͼĴ	          	  */
/* ֵ  	     	                      */
/**********************************************/
void SEND_BUF(uchar *buf)
{
	NRF_CE=0;
	NRF24L01_Write_Reg(WRITE_REG+CONFIG,0x0e);
	NRF_CE=1;
	delay_us(15);
	NRF24L01_TxPacket(buf);
	NRF_CE=0;
	NRF24L01_Write_Reg(WRITE_REG+CONFIG, 0x0f);
	NRF_CE=1;	
}